## TFSA-2022-036: Heap OOB read/write in `SpecializeType`

### CVE Number
CVE-2022-23574

### Impact
There is a typo in TensorFlow's [`SpecializeType`](https://github.com/tensorflow/tensorflow/blob/a1320ec1eac186da1d03f033109191f715b2b130/tensorflow/core/framework/full_type_util.cc#L81-L102) which results in heap OOB read/write:

```cc
for (int i = 0; i < op_def.output_arg_size(); i++) {
  // ...
  for (int j = 0; j < t->args_size(); j++) {
    auto* arg = t->mutable_args(i);
    // ...
  }
}
```

Due to a typo, `arg` is initialized to the `i`th mutable argument in a loop where the loop index is `j`. Hence it is possible to assign to `arg` from outside the vector of arguments. Since this is a mutable proto value, it allows both read and write to outside of bounds data.

### Patches
We have patched the issue in GitHub commit [0657c83d08845cc434175934c642299de2c0f042](https://github.com/tensorflow/tensorflow/commit/0657c83d08845cc434175934c642299de2c0f042).

The fix will be included in TensorFlow 2.8.0. We will also cherrypick this commit on TensorFlow 2.7.1, and TensorFlow 2.6.3, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.
