# -*- coding: utf-8 -*-
#
# Copyright 2011-2012 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# In addition, as a special exception, the copyright holders give
# permission to link the code of portions of this program with the
# OpenSSL library under certain conditions as described in each
# individual source file, and distribute linked combinations
# including the two.
# You must obey the GNU General Public License in all respects
# for all of the code used other than OpenSSL.  If you modify
# file(s) with this exception, you may extend this exception to your
# version of the file(s), but you are not obligated to do so.  If you
# do not wish to do so, delete this exception statement from your
# version.  If you delete this exception statement from all source
# files in the program, then also delete it here.
"""Script that shows the qt gui."""

from __future__ import unicode_literals

import sys

# pylint: disable=E1101,F0401,E0611

if sys.platform != 'win32':
    from twisted.internet import gireactor
    gireactor.install()

    from dbus.mainloop.glib import DBusGMainLoop
    DBusGMainLoop(set_as_default=True)

from twisted.internet import defer, reactor

from ubuntu_sso.main import get_sso_client
from ubuntu_sso.credentials import (
    HELP_TEXT_KEY,
    PING_URL_KEY,
    POLICY_URL_KEY,
    TC_URL_KEY,
)


@defer.inlineCallbacks
def main():
    """Perform a client request to be logged in."""
    d = defer.Deferred()
    client = yield get_sso_client()

    def found(*args):
        """The result was received."""
        d.callback(args)

    client.cred_manager.connect_to_signal('CredentialsFound', found)
    client.cred_manager.connect_to_signal('CredentialsNotFound', found)
    client.cred_manager.connect_to_signal('AuthorizationDenied', found)
    client.cred_manager.connect_to_signal('CredentialsError', found)

    yield client.cred_manager.login('Ubuntu Two',
        {
            HELP_TEXT_KEY: 'This is a test help text.',
            PING_URL_KEY: 'http://www.wikipedia.com/',
            POLICY_URL_KEY: 'http://one.ubuntu.com/',
            TC_URL_KEY: 'http://www.google.com/',
        })
    yield d

    yield client.disconnect()
    reactor.stop()


if __name__ == '__main__':
    main()
    reactor.run()
