#!/usr/bin/python

# This is a GTK information dialog informing the user what is happening, 
# after opening the IRC menu item, which automatically connectes the user
# to the #ubuntustudio-user channel with the username on the installed machine.
# Choices are to accept, or cancel.

from gi.repository import Gtk
import subprocess

# Main class
class IRCWarningDialog:

  # Init the program
  # Init Gtk and get the glade file and connect to its buttons
  def __init__(self):
    self.builder = Gtk.Builder()
    self.builder.add_from_file("/usr/lib/ubuntustudio/irc_auto_starter.glade")
    self.window = self.builder.get_object("ircwarning_dialog")

    # Pipe signals to function names
    dic = { "on_accept_btn_clicked" : self.accept_clicked,
          "on_cancel_btn_clicked" : self.cancel_clicked }

    # Connect the signals
    self.builder.connect_signals(dic)

  #Button functions
  def cancel_clicked(self, widget):
    Gtk.main_quit()

  def accept_clicked(self, widget):
    p = subprocess.Popen(["xchat", "-e", "--url=irc://irc.ubuntu.com/#ubuntustudio"], 
                                    stdout=subprocess.PIPE, 
                                    stderr=subprocess.STDOUT)
    Gtk.main_quit()

  ## Exit window
  def window_close(self, widget):
    Gtk.main_quit()


if __name__ == "__main__":
        ircwarning = IRCWarningDialog()
        ircwarning.window.show()
        Gtk.main()
