
################################################################
# This is a generated script based on design: dac_400m_bd
#
# Though there are limitations about the generated script,
# the main purpose of this utility is to make learning
# IP Integrator Tcl commands easier.
################################################################

namespace eval _tcl {
proc get_script_folder {} {
   set script_path [file normalize [info script]]
   set script_folder [file dirname $script_path]
   return $script_folder
}
}
variable script_folder
set script_folder [_tcl::get_script_folder]

################################################################
# Check if script is running in correct Vivado version.
################################################################
set scripts_vivado_version 2019.1
set current_vivado_version [version -short]

if { [string first $scripts_vivado_version $current_vivado_version] == -1 } {
   puts ""
   catch {common::send_msg_id "BD_TCL-109" "ERROR" "This script was generated using Vivado <$scripts_vivado_version> and is being run in <$current_vivado_version> of Vivado. Please run the script in Vivado <$scripts_vivado_version> then open the design in Vivado <$current_vivado_version>. Upgrade the design by running \"Tools => Report => Report IP Status...\", then run write_bd_tcl to create an updated script."}

   return 1
}

################################################################
# START
################################################################

# To test this script, run the following commands from Vivado Tcl console:
# source dac_400m_bd_script.tcl


# The design that will be created by this Tcl script contains the following 
# module references:
# dac_gearbox_4x2, dac_gearbox_6x8, duc_400m_saturate

# Please add the sources of those modules before sourcing this Tcl script.

# If there is no project opened, this script will create a
# project, but make sure you do not have an existing project
# <./myproj/project_1.xpr> in the current working folder.

set list_projs [get_projects -quiet]
if { $list_projs eq "" } {
   create_project project_1 myproj -part xczu28dr-ffvg1517-1-e
}


# CHANGE DESIGN NAME HERE
variable design_name
set design_name dac_400m_bd

# If you do not already have an existing IP Integrator design open,
# you can create a design using the following command:
#    create_bd_design $design_name

# Creating design if needed
set errMsg ""
set nRet 0

set cur_design [current_bd_design -quiet]
set list_cells [get_bd_cells -quiet]

if { ${design_name} eq "" } {
   # USE CASES:
   #    1) Design_name not set

   set errMsg "Please set the variable <design_name> to a non-empty value."
   set nRet 1

} elseif { ${cur_design} ne "" && ${list_cells} eq "" } {
   # USE CASES:
   #    2): Current design opened AND is empty AND names same.
   #    3): Current design opened AND is empty AND names diff; design_name NOT in project.
   #    4): Current design opened AND is empty AND names diff; design_name exists in project.

   if { $cur_design ne $design_name } {
      common::send_msg_id "BD_TCL-001" "INFO" "Changing value of <design_name> from <$design_name> to <$cur_design> since current design is empty."
      set design_name [get_property NAME $cur_design]
   }
   common::send_msg_id "BD_TCL-002" "INFO" "Constructing design in IPI design <$cur_design>..."

} elseif { ${cur_design} ne "" && $list_cells ne "" && $cur_design eq $design_name } {
   # USE CASES:
   #    5) Current design opened AND has components AND same names.

   set errMsg "Design <$design_name> already exists in your project, please set the variable <design_name> to another value."
   set nRet 1
} elseif { [get_files -quiet ${design_name}.bd] ne "" } {
   # USE CASES: 
   #    6) Current opened design, has components, but diff names, design_name exists in project.
   #    7) No opened design, design_name exists in project.

   set errMsg "Design <$design_name> already exists in your project, please set the variable <design_name> to another value."
   set nRet 2

} else {
   # USE CASES:
   #    8) No opened design, design_name not in project.
   #    9) Current opened design, has components, but diff names, design_name not in project.

   common::send_msg_id "BD_TCL-003" "INFO" "Currently there is no design <$design_name> in project, so creating one..."

   create_bd_design $design_name

   common::send_msg_id "BD_TCL-004" "INFO" "Making design <$design_name> as current_bd_design."
   current_bd_design $design_name

}

common::send_msg_id "BD_TCL-005" "INFO" "Currently the variable <design_name> is equal to \"$design_name\"."

if { $nRet != 0 } {
   catch {common::send_msg_id "BD_TCL-114" "ERROR" $errMsg}
   return $nRet
}

set bCheckIPsPassed 1
##################################################################
# CHECK IPs
##################################################################
set bCheckIPs 1
if { $bCheckIPs == 1 } {
   set list_check_ips "\ 
xilinx.com:ip:fir_compiler:7.2\
"

   set list_ips_missing ""
   common::send_msg_id "BD_TCL-006" "INFO" "Checking if the following IPs exist in the project's IP catalog: $list_check_ips ."

   foreach ip_vlnv $list_check_ips {
      set ip_obj [get_ipdefs -all $ip_vlnv]
      if { $ip_obj eq "" } {
         lappend list_ips_missing $ip_vlnv
      }
   }

   if { $list_ips_missing ne "" } {
      catch {common::send_msg_id "BD_TCL-115" "ERROR" "The following IPs are not found in the IP Catalog:\n  $list_ips_missing\n\nResolution: Please add the repository containing the IP(s) to the project." }
      set bCheckIPsPassed 0
   }

}

##################################################################
# CHECK Modules
##################################################################
set bCheckModules 1
if { $bCheckModules == 1 } {
   set list_check_mods "\ 
dac_gearbox_4x2\
dac_gearbox_6x8\
duc_400m_saturate\
"

   set list_mods_missing ""
   common::send_msg_id "BD_TCL-006" "INFO" "Checking if the following modules exist in the project's sources: $list_check_mods ."

   foreach mod_vlnv $list_check_mods {
      if { [can_resolve_reference $mod_vlnv] == 0 } {
         lappend list_mods_missing $mod_vlnv
      }
   }

   if { $list_mods_missing ne "" } {
      catch {common::send_msg_id "BD_TCL-115" "ERROR" "The following module(s) are not found in the project: $list_mods_missing" }
      common::send_msg_id "BD_TCL-008" "INFO" "Please add source files for the missing module(s) above."
      set bCheckIPsPassed 0
   }
}

if { $bCheckIPsPassed != 1 } {
  common::send_msg_id "BD_TCL-1003" "WARNING" "Will not continue with creation of design due to the error(s) above."
  return 3
}

##################################################################
# DESIGN PROCs
##################################################################



# Procedure to create entire design; Provide argument to make
# procedure reusable. If parentCell is "", will use root.
proc create_root_design { parentCell } {

  variable script_folder
  variable design_name

  if { $parentCell eq "" } {
     set parentCell [get_bd_cells /]
  }

  # Get object for parentCell
  set parentObj [get_bd_cells $parentCell]
  if { $parentObj == "" } {
     catch {common::send_msg_id "BD_TCL-100" "ERROR" "Unable to find parent cell <$parentCell>!"}
     return
  }

  # Make sure parentObj is hier blk
  set parentType [get_property TYPE $parentObj]
  if { $parentType ne "hier" } {
     catch {common::send_msg_id "BD_TCL-101" "ERROR" "Parent <$parentObj> has TYPE = <$parentType>. Expected to be <hier>."}
     return
  }

  # Save current instance; Restore later
  set oldCurInst [current_bd_instance .]

  # Set parent object as current
  current_bd_instance $parentObj


  # Create interface ports

  # Create ports
  set dac_data_in_resetn_dclk [ create_bd_port -dir I -type rst dac_data_in_resetn_dclk ]
  set dac_data_in_resetn_dclk2x [ create_bd_port -dir I -type rst dac_data_in_resetn_dclk2x ]
  set dac_data_in_resetn_rclk [ create_bd_port -dir I -type rst dac_data_in_resetn_rclk ]
  set dac_data_in_tdata [ create_bd_port -dir I -from 127 -to 0 -type data dac_data_in_tdata ]
  set dac_data_in_tready [ create_bd_port -dir O -type data dac_data_in_tready ]
  set dac_data_in_tvalid [ create_bd_port -dir I -type data dac_data_in_tvalid ]
  set dac_data_out_tdata [ create_bd_port -dir O -from 255 -to 0 -type data dac_data_out_tdata ]
  set dac_data_out_tready [ create_bd_port -dir I -type data dac_data_out_tready ]
  set dac_data_out_tvalid [ create_bd_port -dir O -type data dac_data_out_tvalid ]
  set data_clk [ create_bd_port -dir I -type clk data_clk ]
  set_property -dict [ list \
   CONFIG.FREQ_HZ {122880000} \
 ] $data_clk
  set data_clk_2x [ create_bd_port -dir I -type clk data_clk_2x ]
  set_property -dict [ list \
   CONFIG.ASSOCIATED_RESET {dac_data_in_resetn_dclk2x} \
   CONFIG.FREQ_HZ {245760000} \
 ] $data_clk_2x
  set rfdc_clk [ create_bd_port -dir I -type clk rfdc_clk ]
  set_property -dict [ list \
   CONFIG.FREQ_HZ {184320000} \
 ] $rfdc_clk

  # Create instance: dac_gearbox_4x2_0, and set properties
  set block_name dac_gearbox_4x2
  set block_cell_name dac_gearbox_4x2_0
  if { [catch {set dac_gearbox_4x2_0 [create_bd_cell -type module -reference $block_name $block_cell_name] } errmsg] } {
     catch {common::send_msg_id "BD_TCL-105" "ERROR" "Unable to add referenced block <$block_name>. Please add the files for ${block_name}'s definition into the project."}
     return 1
   } elseif { $dac_gearbox_4x2_0 eq "" } {
     catch {common::send_msg_id "BD_TCL-106" "ERROR" "Unable to referenced block <$block_name>. Please add the files for ${block_name}'s definition into the project."}
     return 1
   }
  
  # Create instance: dac_gearbox_6x8_0, and set properties
  set block_name dac_gearbox_6x8
  set block_cell_name dac_gearbox_6x8_0
  if { [catch {set dac_gearbox_6x8_0 [create_bd_cell -type module -reference $block_name $block_cell_name] } errmsg] } {
     catch {common::send_msg_id "BD_TCL-105" "ERROR" "Unable to add referenced block <$block_name>. Please add the files for ${block_name}'s definition into the project."}
     return 1
   } elseif { $dac_gearbox_6x8_0 eq "" } {
     catch {common::send_msg_id "BD_TCL-106" "ERROR" "Unable to referenced block <$block_name>. Please add the files for ${block_name}'s definition into the project."}
     return 1
   }
  
  # Create instance: dac_interpolator, and set properties
  set dac_interpolator [ create_bd_cell -type ip -vlnv xilinx.com:ip:fir_compiler:7.2 dac_interpolator ]
  set_property -dict [ list \
   CONFIG.Clock_Frequency {245.76} \
   CONFIG.CoefficientVector {-7,0,24,37,0,-78,-107,0,189,244,0,-389,-484,0,723,873,0,-1245,-1473,0,2029,2364,0,-3177,-3668,0,4862,5592,0,-7418,-8579,0,11675,13820,0,-20461,-26115,0,53699,108144,131069,108144,53699,0,-26115,-20461,0,13820,11675,0,-8579,-7418,0,5592,4862,0,-3668,-3177,0,2364,2029,0,-1473,-1245,0,873,723,0,-484,-389,0,244,189,0,-107,-78,0,37,24,0,-7} \
   CONFIG.Coefficient_Fractional_Bits {0} \
   CONFIG.Coefficient_Sets {1} \
   CONFIG.Coefficient_Sign {Signed} \
   CONFIG.Coefficient_Structure {Inferred} \
   CONFIG.Coefficient_Width {18} \
   CONFIG.ColumnConfig {27} \
   CONFIG.Decimation_Rate {1} \
   CONFIG.Filter_Architecture {Systolic_Multiply_Accumulate} \
   CONFIG.Filter_Type {Interpolation} \
   CONFIG.Has_ARESETn {true} \
   CONFIG.Interpolation_Rate {3} \
   CONFIG.Number_Channels {1} \
   CONFIG.Number_Paths {2} \
   CONFIG.Output_Rounding_Mode {Convergent_Rounding_to_Even} \
   CONFIG.Output_Width {18} \
   CONFIG.Quantization {Integer_Coefficients} \
   CONFIG.RateSpecification {Frequency_Specification} \
   CONFIG.Reset_Data_Vector {false} \
   CONFIG.S_DATA_Has_FIFO {false} \
   CONFIG.Sample_Frequency {491.52} \
   CONFIG.Zero_Pack_Factor {1} \
 ] $dac_interpolator

  # Create instance: duc_400m_saturate_0, and set properties
  set block_name duc_400m_saturate
  set block_cell_name duc_400m_saturate_0
  if { [catch {set duc_400m_saturate_0 [create_bd_cell -type module -reference $block_name $block_cell_name] } errmsg] } {
     catch {common::send_msg_id "BD_TCL-105" "ERROR" "Unable to add referenced block <$block_name>. Please add the files for ${block_name}'s definition into the project."}
     return 1
   } elseif { $duc_400m_saturate_0 eq "" } {
     catch {common::send_msg_id "BD_TCL-106" "ERROR" "Unable to referenced block <$block_name>. Please add the files for ${block_name}'s definition into the project."}
     return 1
   }
  
  # Create port connections
  connect_bd_net -net dac_data_in_1 [get_bd_ports dac_data_in_tdata] [get_bd_pins dac_gearbox_4x2_0/data_in_1x]
  connect_bd_net -net dac_data_in_resetn_dclk_1 [get_bd_ports dac_data_in_resetn_dclk] [get_bd_pins dac_gearbox_4x2_0/reset_n_1x] [get_bd_pins dac_gearbox_6x8_0/ac1Reset_n]
  connect_bd_net -net dac_data_in_resetn_rclk_1 [get_bd_ports dac_data_in_resetn_rclk] [get_bd_pins dac_gearbox_6x8_0/arReset_n]
  connect_bd_net -net dac_data_out_tready_1 [get_bd_ports dac_data_out_tready] [get_bd_pins dac_gearbox_6x8_0/rReadyForOutput]
  connect_bd_net -net dac_data_valid_in_1 [get_bd_ports dac_data_in_tvalid] [get_bd_pins dac_gearbox_4x2_0/valid_in_1x]
  connect_bd_net -net dac_gearbox_4x2_0_data_out_2x [get_bd_pins dac_gearbox_4x2_0/data_out_2x] [get_bd_pins dac_interpolator/s_axis_data_tdata]
  connect_bd_net -net dac_gearbox_4x2_0_ready_out_1x [get_bd_ports dac_data_in_tready] [get_bd_pins dac_gearbox_4x2_0/ready_out_1x]
  connect_bd_net -net dac_gearbox_4x2_0_valid_out_2x [get_bd_pins dac_gearbox_4x2_0/valid_out_2x] [get_bd_pins dac_interpolator/s_axis_data_tvalid]
  connect_bd_net -net dac_gearbox_6x8_0_rDataOut [get_bd_ports dac_data_out_tdata] [get_bd_pins dac_gearbox_6x8_0/rDataOut]
  connect_bd_net -net dac_gearbox_6x8_0_rDataValidOut [get_bd_ports dac_data_out_tvalid] [get_bd_pins dac_gearbox_6x8_0/rDataValidOut]
  connect_bd_net -net dac_interpolator_m_axis_data_tdata [get_bd_pins dac_interpolator/m_axis_data_tdata] [get_bd_pins duc_400m_saturate_0/cDataIn]
  connect_bd_net -net dac_interpolator_m_axis_data_tvalid [get_bd_pins dac_interpolator/m_axis_data_tvalid] [get_bd_pins duc_400m_saturate_0/cDataValidIn]
  connect_bd_net -net data_clk_1 [get_bd_ports data_clk] [get_bd_pins dac_gearbox_4x2_0/clk1x] [get_bd_pins dac_gearbox_6x8_0/Clk1x]
  connect_bd_net -net data_clk_2x_1 [get_bd_ports data_clk_2x] [get_bd_pins dac_gearbox_4x2_0/clk2x] [get_bd_pins dac_gearbox_6x8_0/Clk2x] [get_bd_pins dac_interpolator/aclk] [get_bd_pins duc_400m_saturate_0/Clk]
  connect_bd_net -net data_resetn_dclk2x_1 [get_bd_ports dac_data_in_resetn_dclk2x] [get_bd_pins dac_gearbox_6x8_0/ac2Reset_n] [get_bd_pins dac_interpolator/aresetn]
  connect_bd_net -net duc_400m_saturate_0_cDataOut [get_bd_pins dac_gearbox_6x8_0/c2DataIn] [get_bd_pins duc_400m_saturate_0/cDataOut]
  connect_bd_net -net duc_400m_saturate_0_cDataValidOut [get_bd_pins dac_gearbox_6x8_0/c2DataValidIn] [get_bd_pins duc_400m_saturate_0/cDataValidOut]
  connect_bd_net -net rfdc_clk_1 [get_bd_ports rfdc_clk] [get_bd_pins dac_gearbox_6x8_0/RfClk]

  # Create address segments


  # Restore current instance
  current_bd_instance $oldCurInst

  validate_bd_design
  save_bd_design
}
# End of create_root_design()


##################################################################
# MAIN FLOW
##################################################################

create_root_design ""


