/* youku-video-search.c generated by valac 0.20.1, the Vala compiler
 * generated from youku-video-search.vala, do not modify */

/*
 * Copyright (C) 2013 National University of Defense Technology(NUDT) & Kylin Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Weihua Zhang <fly2high@126.com>
 * Authored by shijing <jingshi@ubuntukylin.com>
 * Modified Information:
 * 1. Modify build_search_uri function , building search condition.
 * 2. Reimplement the process_search_results function, get the information of video from youku.
 *
 */
/*
 * Copyright (C) 2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Pawel Stolowski <pawel.stolowski@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <json-glib/json-glib.h>
#include <time.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define UNITY_VIDEO_LENS_TYPE_REMOTE_VIDEO_FILE (unity_video_lens_remote_video_file_get_type ())
typedef struct _UnityVideoLensRemoteVideoFile UnityVideoLensRemoteVideoFile;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;

#define UNITY_VIDEO_LENS_TYPE_REMOTE_VIDEO_DETAILS (unity_video_lens_remote_video_details_get_type ())
typedef struct _UnityVideoLensRemoteVideoDetails UnityVideoLensRemoteVideoDetails;
#define __vala_JsonArray_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonArray_free (var), NULL)))
#define __vala_JsonObject_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonObject_free (var), NULL)))
typedef struct _Block5Data Block5Data;

struct _UnityVideoLensRemoteVideoFile {
	gchar* title;
	gchar* comment;
	gchar* uri;
	gchar* icon;
	gchar* details_uri;
	gchar* price;
	gint category;
};

struct _Block3Data {
	int _ref_count_;
	GString* res;
	guint len;
	gchar* separator;
};

struct _Block4Data {
	int _ref_count_;
	gchar** res;
	gint res_length1;
	gint _res_size_;
};

struct _UnityVideoLensRemoteVideoDetails {
	gchar* title;
	gchar* description;
	gchar* uri;
	gchar* image;
	gchar* source;
	gchar* release_date;
	gint duration;
	gchar** directors;
	gint directors_length1;
	gchar* starring;
	gchar** genres;
	gint genres_length1;
	gchar* uploaded_by;
	gchar* date_uploaded;
	gchar* price;
};

struct _Block5Data {
	int _ref_count_;
	GeeArrayList* results;
};



#define UNITY_VIDEO_LENS_UBUNTU_VIDEO_SEARCH_SERVER "http://www.soku.com/search_video/"
gchar* unity_video_lens_ubuntu_video_search_sources_uri (void);
gchar* unity_video_lens_ubuntu_video_search_recommendations_uri (void);
gchar* unity_video_lens_ubuntu_video_search_build_search_uri (const gchar* query, GeeArrayList* sources);
GType unity_video_lens_remote_video_file_get_type (void) G_GNUC_CONST;
UnityVideoLensRemoteVideoFile* unity_video_lens_remote_video_file_dup (const UnityVideoLensRemoteVideoFile* self);
void unity_video_lens_remote_video_file_free (UnityVideoLensRemoteVideoFile* self);
void unity_video_lens_remote_video_file_copy (const UnityVideoLensRemoteVideoFile* self, UnityVideoLensRemoteVideoFile* dest);
void unity_video_lens_remote_video_file_destroy (UnityVideoLensRemoteVideoFile* self);
GeeArrayList* unity_video_lens_ubuntu_video_search_process_search_results (const gchar* json_data, gboolean is_treat_yourself, GError** error);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
gchar* unity_video_lens_ubuntu_video_search_join_array (JsonArray* array, const gchar* separator);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda13_ (Block3Data* _data3_, JsonArray* a, guint index, JsonNode* node);
static void ___lambda13__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
gchar** unity_video_lens_ubuntu_video_search_json_array_to_str_array (JsonArray* array, int* result_length1);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda12_ (Block4Data* _data4_, JsonArray* a, guint index, JsonNode* node);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void ___lambda12__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static gchar** _vala_array_dup1 (gchar** self, int length);
GType unity_video_lens_remote_video_details_get_type (void) G_GNUC_CONST;
UnityVideoLensRemoteVideoDetails* unity_video_lens_remote_video_details_dup (const UnityVideoLensRemoteVideoDetails* self);
void unity_video_lens_remote_video_details_free (UnityVideoLensRemoteVideoDetails* self);
void unity_video_lens_remote_video_details_copy (const UnityVideoLensRemoteVideoDetails* self, UnityVideoLensRemoteVideoDetails* dest);
void unity_video_lens_remote_video_details_destroy (UnityVideoLensRemoteVideoDetails* self);
void unity_video_lens_ubuntu_video_search_process_details_results (const gchar* json_data, UnityVideoLensRemoteVideoDetails* result, GError** error);
static JsonObject* _vala_JsonObject_copy (JsonObject* self);
static JsonArray* _vala_JsonArray_copy (JsonArray* self);
static void _vala_JsonArray_free (JsonArray* self);
static void _vala_JsonObject_free (JsonObject* self);
GeeArrayList* unity_video_lens_ubuntu_video_search_process_sources_results (const gchar* json_data, GError** error);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda8_ (Block5Data* _data5_, JsonArray* array, guint index, JsonNode* node);
static void ___lambda8__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


gchar* unity_video_lens_ubuntu_video_search_sources_uri (void) {
	gchar* result = NULL;
	gchar* _tmp0_;
	_tmp0_ = g_strdup (UNITY_VIDEO_LENS_UBUNTU_VIDEO_SEARCH_SERVER);
	result = _tmp0_;
	return result;
}


gchar* unity_video_lens_ubuntu_video_search_recommendations_uri (void) {
	gchar* result = NULL;
	gchar* _tmp0_;
	_tmp0_ = g_strdup (UNITY_VIDEO_LENS_UBUNTU_VIDEO_SEARCH_SERVER "/search?q=&sources=Amazon");
	result = _tmp0_;
	return result;
}


gchar* unity_video_lens_ubuntu_video_search_build_search_uri (const gchar* query, GeeArrayList* sources) {
	gchar* result = NULL;
	GString* _tmp0_;
	GString* uri;
	GString* _tmp1_;
	GString* _tmp2_;
	GString* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GeeArrayList* _tmp8_;
	gboolean _tmp12_;
	GString* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	g_return_val_if_fail (query != NULL, NULL);
	_tmp0_ = g_string_new ("");
	uri = _tmp0_;
	_tmp1_ = uri;
	g_string_append (_tmp1_, UNITY_VIDEO_LENS_UBUNTU_VIDEO_SEARCH_SERVER);
	_tmp2_ = uri;
	g_string_append (_tmp2_, "q_");
	_tmp3_ = uri;
	_tmp4_ = query;
	_tmp5_ = g_uri_escape_string (_tmp4_, "", FALSE);
	_tmp6_ = _tmp5_;
	g_string_append (_tmp3_, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp8_ = sources;
	if (_tmp8_ != NULL) {
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp9_ = sources;
		_tmp10_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp7_ = _tmp11_ > 0;
	} else {
		_tmp7_ = FALSE;
	}
	_tmp12_ = _tmp7_;
	if (_tmp12_) {
		GString* _tmp13_;
		GString* _tmp14_;
		GeeArrayList* _tmp15_;
		gpointer _tmp16_ = NULL;
		gchar* _tmp17_;
		_tmp13_ = uri;
		g_string_append (_tmp13_, "&sources=");
		_tmp14_ = uri;
		_tmp15_ = sources;
		_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, 0);
		_tmp17_ = (gchar*) _tmp16_;
		g_string_append (_tmp14_, _tmp17_);
		_g_free0 (_tmp17_);
		{
			gint i;
			i = 1;
			{
				gboolean _tmp18_;
				_tmp18_ = TRUE;
				while (TRUE) {
					gboolean _tmp19_;
					gint _tmp21_;
					GeeArrayList* _tmp22_;
					gint _tmp23_;
					gint _tmp24_;
					GString* _tmp25_;
					GString* _tmp26_;
					GeeArrayList* _tmp27_;
					gint _tmp28_;
					gpointer _tmp29_ = NULL;
					gchar* _tmp30_;
					_tmp19_ = _tmp18_;
					if (!_tmp19_) {
						gint _tmp20_;
						_tmp20_ = i;
						i = _tmp20_ + 1;
					}
					_tmp18_ = FALSE;
					_tmp21_ = i;
					_tmp22_ = sources;
					_tmp23_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp22_);
					_tmp24_ = _tmp23_;
					if (!(_tmp21_ < _tmp24_)) {
						break;
					}
					_tmp25_ = uri;
					g_string_append (_tmp25_, ",");
					_tmp26_ = uri;
					_tmp27_ = sources;
					_tmp28_ = i;
					_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp27_, _tmp28_);
					_tmp30_ = (gchar*) _tmp29_;
					g_string_append (_tmp26_, _tmp30_);
					_g_free0 (_tmp30_);
				}
			}
		}
	}
	_tmp31_ = uri;
	_tmp32_ = _tmp31_->str;
	_tmp33_ = g_strdup (_tmp32_);
	result = _tmp33_;
	_g_string_free0 (uri);
	return result;
}


/**
   * Parses JSON data returned by search requests, returns list of videos.
   */
static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


GeeArrayList* unity_video_lens_ubuntu_video_search_process_search_results (const gchar* json_data, gboolean is_treat_yourself, GError** error) {
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* videos;
	UnityVideoLensRemoteVideoFile video = {0};
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* content;
	const gchar* _tmp3_;
	gint _tmp4_ = 0;
	gint iIndex;
	const gchar* _tmp5_;
	gint _tmp6_ = 0;
	gint iEnd;
	const gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gchar* _tmp11_ = NULL;
	GList* lilist;
	const gchar* _tmp12_;
	gint _tmp13_ = 0;
	gint liIndex;
	GList* _tmp23_;
	g_return_val_if_fail (json_data != NULL, NULL);
	_tmp0_ = gee_array_list_new (UNITY_VIDEO_LENS_TYPE_REMOTE_VIDEO_FILE, (GBoxedCopyFunc) unity_video_lens_remote_video_file_dup, unity_video_lens_remote_video_file_free, NULL);
	videos = _tmp0_;
	memset (&video, 0, sizeof (UnityVideoLensRemoteVideoFile));
	_tmp1_ = json_data;
	_tmp2_ = g_strdup (_tmp1_);
	content = _tmp2_;
	_tmp3_ = content;
	_tmp4_ = string_index_of (_tmp3_, "<div class=\"sk-vlist", 0);
	iIndex = _tmp4_;
	_tmp5_ = content;
	_tmp6_ = string_index_of (_tmp5_, "<div class=\"sk-pager", 0);
	iEnd = _tmp6_;
	_tmp7_ = content;
	_tmp8_ = iIndex;
	_tmp9_ = iEnd;
	_tmp10_ = iIndex;
	_tmp11_ = string_substring (_tmp7_, (glong) _tmp8_, (glong) (_tmp9_ - _tmp10_));
	_g_free0 (content);
	content = _tmp11_;
	lilist = NULL;
	_tmp12_ = content;
	_tmp13_ = string_index_of (_tmp12_, "<div class=\"v-meta-entry", 0);
	liIndex = _tmp13_;
	while (TRUE) {
		gint _tmp14_;
		const gchar* _tmp15_;
		gint _tmp16_;
		gchar* _tmp17_ = NULL;
		const gchar* _tmp18_;
		gint _tmp19_;
		gchar* _tmp20_ = NULL;
		const gchar* _tmp21_;
		gint _tmp22_ = 0;
		_tmp14_ = liIndex;
		if (!(_tmp14_ != (-1))) {
			break;
		}
		_tmp15_ = content;
		_tmp16_ = liIndex;
		_tmp17_ = string_substring (_tmp15_, (glong) 0, (glong) (_tmp16_ + 600));
		lilist = g_list_append (lilist, _tmp17_);
		_tmp18_ = content;
		_tmp19_ = liIndex;
		_tmp20_ = string_substring (_tmp18_, (glong) (_tmp19_ + 600), (glong) (-1));
		_g_free0 (content);
		content = _tmp20_;
		_tmp21_ = content;
		_tmp22_ = string_index_of (_tmp21_, "<div class=\"v-meta-entry", 0);
		liIndex = _tmp22_;
	}
	_tmp23_ = lilist;
	{
		GList* li_collection = NULL;
		GList* li_it = NULL;
		li_collection = _tmp23_;
		for (li_it = li_collection; li_it != NULL; li_it = li_it->next) {
			gchar* _tmp24_;
			gchar* li = NULL;
			_tmp24_ = g_strdup ((const gchar*) li_it->data);
			li = _tmp24_;
			{
				const gchar* _tmp25_;
				gint _tmp26_ = 0;
				const gchar* _tmp27_;
				gint _tmp28_;
				gchar* _tmp29_ = NULL;
				gchar* _tmp30_;
				gint _tmp31_ = 0;
				const gchar* _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				gchar* _tmp35_ = NULL;
				const gchar* _tmp36_;
				gint _tmp37_ = 0;
				const gchar* _tmp38_;
				gint _tmp39_;
				gchar* _tmp40_ = NULL;
				gchar* _tmp41_;
				gint _tmp42_ = 0;
				const gchar* _tmp43_;
				gint _tmp44_;
				gint _tmp45_;
				gchar* _tmp46_ = NULL;
				const gchar* _tmp47_;
				gint _tmp48_ = 0;
				const gchar* _tmp49_;
				gint _tmp50_;
				gchar* _tmp51_ = NULL;
				const gchar* _tmp52_;
				gint _tmp53_ = 0;
				const gchar* _tmp54_;
				gint _tmp55_;
				gchar* _tmp56_ = NULL;
				gchar* _tmp57_;
				gint _tmp58_ = 0;
				const gchar* _tmp59_;
				gint _tmp60_;
				gint _tmp61_;
				gchar* _tmp62_ = NULL;
				const gchar* _tmp63_;
				gint _tmp64_ = 0;
				const gchar* _tmp65_;
				gint _tmp66_;
				gchar* _tmp67_ = NULL;
				gchar* _tmp68_;
				gint _tmp69_ = 0;
				const gchar* _tmp70_;
				gint _tmp71_;
				gint _tmp72_;
				gchar* _tmp73_ = NULL;
				GeeArrayList* _tmp74_;
				UnityVideoLensRemoteVideoFile _tmp75_;
				_tmp25_ = li;
				_tmp26_ = string_index_of (_tmp25_, "href=\"http://v.youku.com/v_show/id_", 0);
				iIndex = _tmp26_;
				_tmp27_ = li;
				_tmp28_ = iIndex;
				_tmp29_ = string_substring (_tmp27_, (glong) _tmp28_, (glong) (-1));
				_tmp30_ = _tmp29_;
				_tmp31_ = string_index_of (_tmp30_, "\" ", 0);
				iEnd = _tmp31_;
				_g_free0 (_tmp30_);
				_tmp32_ = li;
				_tmp33_ = iIndex;
				_tmp34_ = iEnd;
				_tmp35_ = string_substring (_tmp32_, (glong) (_tmp33_ + 6), (glong) (_tmp34_ - 6));
				_g_free0 (video.uri);
				video.uri = _tmp35_;
				_tmp36_ = li;
				_tmp37_ = string_index_of (_tmp36_, "<a title=", 0);
				iIndex = _tmp37_;
				_tmp38_ = li;
				_tmp39_ = iIndex;
				_tmp40_ = string_substring (_tmp38_, (glong) _tmp39_, (glong) (-1));
				_tmp41_ = _tmp40_;
				_tmp42_ = string_index_of (_tmp41_, "\" ", 0);
				iEnd = _tmp42_;
				_g_free0 (_tmp41_);
				_tmp43_ = li;
				_tmp44_ = iIndex;
				_tmp45_ = iEnd;
				_tmp46_ = string_substring (_tmp43_, (glong) (_tmp44_ + 10), (glong) (_tmp45_ - 10));
				_g_free0 (video.title);
				video.title = _tmp46_;
				_tmp47_ = li;
				_tmp48_ = string_index_of (_tmp47_, "<img alt", 0);
				iIndex = _tmp48_;
				_tmp49_ = li;
				_tmp50_ = iIndex;
				_tmp51_ = string_substring (_tmp49_, (glong) _tmp50_, (glong) (-1));
				_g_free0 (li);
				li = _tmp51_;
				_tmp52_ = li;
				_tmp53_ = string_index_of (_tmp52_, "src", 0);
				iIndex = _tmp53_;
				_tmp54_ = li;
				_tmp55_ = iIndex;
				_tmp56_ = string_substring (_tmp54_, (glong) _tmp55_, (glong) (-1));
				_tmp57_ = _tmp56_;
				_tmp58_ = string_index_of (_tmp57_, "onerror", 0);
				iEnd = _tmp58_;
				_g_free0 (_tmp57_);
				_tmp59_ = li;
				_tmp60_ = iIndex;
				_tmp61_ = iEnd;
				_tmp62_ = string_substring (_tmp59_, (glong) (_tmp60_ + 5), (glong) (_tmp61_ - 7));
				_g_free0 (video.icon);
				video.icon = _tmp62_;
				_tmp63_ = li;
				_tmp64_ = string_index_of (_tmp63_, "span class=\"v-time", 0);
				iIndex = _tmp64_;
				_tmp65_ = li;
				_tmp66_ = iIndex;
				_tmp67_ = string_substring (_tmp65_, (glong) _tmp66_, (glong) (-1));
				_tmp68_ = _tmp67_;
				_tmp69_ = string_index_of (_tmp68_, "</span", 0);
				iEnd = _tmp69_;
				_g_free0 (_tmp68_);
				_tmp70_ = li;
				_tmp71_ = iIndex;
				_tmp72_ = iEnd;
				_tmp73_ = string_substring (_tmp70_, (glong) (_tmp71_ + 20), (glong) (_tmp72_ - 20));
				_g_free0 (video.comment);
				video.comment = _tmp73_;
				_tmp74_ = videos;
				_tmp75_ = video;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp74_, &_tmp75_);
				_g_free0 (li);
			}
		}
	}
	result = videos;
	__g_list_free__g_free0_0 (lilist);
	_g_free0 (content);
	unity_video_lens_remote_video_file_destroy (&video);
	return result;
}


/**
   * Joins elements of JSON array of strings.
   */
static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_string_free0 (_data3_->res);
		_g_free0 (_data3_->separator);
		g_slice_free (Block3Data, _data3_);
	}
}


static void __lambda13_ (Block3Data* _data3_, JsonArray* a, guint index, JsonNode* node) {
	JsonNode* _tmp0_;
	const gchar* _tmp1_ = NULL;
	guint _tmp2_;
	g_return_if_fail (a != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_string (_tmp0_);
	g_string_append (_data3_->res, _tmp1_);
	_tmp2_ = index;
	if (_tmp2_ < (_data3_->len - 1)) {
		const gchar* _tmp3_;
		_tmp3_ = _data3_->separator;
		g_string_append (_data3_->res, _tmp3_);
	}
}


static void ___lambda13__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda13_ (self, array, index_, element_node);
}


gchar* unity_video_lens_ubuntu_video_search_join_array (JsonArray* array, const gchar* separator) {
	gchar* result = NULL;
	Block3Data* _data3_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GString* _tmp2_;
	JsonArray* _tmp3_;
	guint _tmp4_ = 0U;
	JsonArray* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (array != NULL, NULL);
	g_return_val_if_fail (separator != NULL, NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_tmp0_ = separator;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data3_->separator);
	_data3_->separator = _tmp1_;
	_tmp2_ = g_string_new ("");
	_data3_->res = _tmp2_;
	_tmp3_ = array;
	_tmp4_ = json_array_get_length (_tmp3_);
	_data3_->len = _tmp4_;
	_tmp5_ = array;
	json_array_foreach_element (_tmp5_, ___lambda13__json_array_foreach, _data3_);
	_tmp6_ = _data3_->res->str;
	_tmp7_ = g_strdup (_tmp6_);
	result = _tmp7_;
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return result;
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_data4_->res = (_vala_array_free (_data4_->res, _data4_->res_length1, (GDestroyNotify) g_free), NULL);
		g_slice_free (Block4Data, _data4_);
	}
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void __lambda12_ (Block4Data* _data4_, JsonArray* a, guint index, JsonNode* node) {
	JsonNode* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	g_return_if_fail (a != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_string (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	_vala_array_add1 (&_data4_->res, &_data4_->res_length1, &_data4_->_res_size_, _tmp2_);
}


static void ___lambda12__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda12_ (self, array, index_, element_node);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


gchar** unity_video_lens_ubuntu_video_search_json_array_to_str_array (JsonArray* array, int* result_length1) {
	gchar** result = NULL;
	Block4Data* _data4_;
	gchar** _tmp0_ = NULL;
	JsonArray* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	g_return_val_if_fail (array != NULL, NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_data4_->res = _tmp0_;
	_data4_->res_length1 = 0;
	_data4_->_res_size_ = _data4_->res_length1;
	_tmp1_ = array;
	json_array_foreach_element (_tmp1_, ___lambda12__json_array_foreach, _data4_);
	_tmp2_ = (_data4_->res != NULL) ? _vala_array_dup1 (_data4_->res, _data4_->res_length1) : ((gpointer) _data4_->res);
	_tmp2__length1 = _data4_->res_length1;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return result;
}


static JsonObject* _vala_JsonObject_copy (JsonObject* self) {
	return g_boxed_copy (json_object_get_type (), self);
}


static gpointer __vala_JsonObject_copy0 (gpointer self) {
	return self ? _vala_JsonObject_copy (self) : NULL;
}


static gchar* g_time_format (struct tm *self, const gchar* format) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
	g_return_val_if_fail (format != NULL, NULL);
	_tmp0_ = g_new0 (gchar, 64);
	buffer = _tmp0_;
	buffer_length1 = 64;
	_buffer_size_ = buffer_length1;
	_tmp1_ = buffer;
	_tmp1__length1 = buffer_length1;
	_tmp2_ = format;
	strftime (_tmp1_, _tmp1__length1, _tmp2_, &(*self));
	_tmp3_ = buffer;
	_tmp3__length1 = buffer_length1;
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
	result = _tmp4_;
	buffer = (g_free (buffer), NULL);
	return result;
}


static JsonArray* _vala_JsonArray_copy (JsonArray* self) {
	return g_boxed_copy (json_array_get_type (), self);
}


static gpointer __vala_JsonArray_copy0 (gpointer self) {
	return self ? _vala_JsonArray_copy (self) : NULL;
}


static void _vala_JsonArray_free (JsonArray* self) {
	g_boxed_free (json_array_get_type (), self);
}


static void _vala_JsonObject_free (JsonObject* self) {
	g_boxed_free (json_object_get_type (), self);
}


void unity_video_lens_ubuntu_video_search_process_details_results (const gchar* json_data, UnityVideoLensRemoteVideoDetails* result, GError** error) {
	JsonParser* _tmp0_;
	JsonParser* parser;
	const gchar* _tmp1_;
	JsonNode* _tmp2_ = NULL;
	JsonObject* _tmp3_ = NULL;
	JsonObject* _tmp4_;
	JsonObject* details;
	UnityVideoLensRemoteVideoDetails video = {0};
	JsonObject* _tmp5_;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	JsonObject* _tmp8_;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	JsonObject* _tmp11_;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	JsonObject* _tmp14_;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	JsonObject* _tmp17_;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp25_ = NULL;
	JsonObject* _tmp26_;
	gboolean _tmp27_ = FALSE;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	JsonObject* _tmp32_;
	gboolean _tmp33_ = FALSE;
	gchar** _tmp37_ = NULL;
	JsonObject* _tmp38_;
	gboolean _tmp39_ = FALSE;
	JsonObject* _tmp46_;
	gboolean _tmp47_ = FALSE;
	gchar** _tmp53_ = NULL;
	JsonObject* _tmp54_;
	gboolean _tmp55_ = FALSE;
	JsonObject* _tmp62_;
	gboolean _tmp63_ = FALSE;
	JsonObject* _tmp67_;
	gboolean _tmp68_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (json_data != NULL);
	_tmp0_ = json_parser_new ();
	parser = _tmp0_;
	_tmp1_ = json_data;
	json_parser_load_from_data (parser, _tmp1_, (gssize) (-1), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (parser);
		return;
	}
	_tmp2_ = json_parser_get_root (parser);
	_tmp3_ = json_node_get_object (_tmp2_);
	_tmp4_ = __vala_JsonObject_copy0 (_tmp3_);
	details = _tmp4_;
	memset (&video, 0, sizeof (UnityVideoLensRemoteVideoDetails));
	_tmp5_ = details;
	_tmp6_ = json_object_get_string_member (_tmp5_, "title");
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 (video.title);
	video.title = _tmp7_;
	_tmp8_ = details;
	_tmp9_ = json_object_get_string_member (_tmp8_, "image");
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 (video.image);
	video.image = _tmp10_;
	_tmp11_ = details;
	_tmp12_ = json_object_get_string_member (_tmp11_, "description");
	_tmp13_ = g_strdup (_tmp12_);
	_g_free0 (video.description);
	video.description = _tmp13_;
	_tmp14_ = details;
	_tmp15_ = json_object_get_string_member (_tmp14_, "source");
	_tmp16_ = g_strdup (_tmp15_);
	_g_free0 (video.source);
	video.source = _tmp16_;
	_tmp17_ = details;
	_tmp18_ = json_object_has_member (_tmp17_, "release_date");
	if (_tmp18_) {
		struct tm release_date = {0};
		JsonObject* _tmp19_;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		memset (&release_date, 0, sizeof (struct tm));
		_tmp19_ = details;
		_tmp20_ = json_object_get_string_member (_tmp19_, "release_date");
		_tmp21_ = strptime (_tmp20_, "%Y-%m-%d", &release_date);
		if (_tmp21_ != NULL) {
			gchar* _tmp22_ = NULL;
			_tmp22_ = g_time_format (&release_date, "%Y");
			_g_free0 (video.release_date);
			video.release_date = _tmp22_;
		} else {
			JsonObject* _tmp23_;
			const gchar* _tmp24_ = NULL;
			_tmp23_ = details;
			_tmp24_ = json_object_get_string_member (_tmp23_, "release_date");
			g_warning ("youku-video-search.vala:176: Failed to parse release_date: '%s'", _tmp24_);
		}
	}
	_tmp26_ = details;
	_tmp27_ = json_object_has_member (_tmp26_, "formatted_price");
	if (_tmp27_) {
		JsonObject* _tmp28_;
		const gchar* _tmp29_ = NULL;
		_tmp28_ = details;
		_tmp29_ = json_object_get_string_member (_tmp28_, "formatted_price");
		_tmp25_ = _tmp29_;
	} else {
		_tmp25_ = "";
	}
	_tmp30_ = _tmp25_;
	_tmp31_ = g_strdup (_tmp30_);
	_g_free0 (video.price);
	video.price = _tmp31_;
	video.duration = 0;
	_tmp32_ = details;
	_tmp33_ = json_object_has_member (_tmp32_, "duration");
	if (_tmp33_) {
		JsonObject* _tmp34_;
		const gchar* _tmp35_ = NULL;
		gint _tmp36_ = 0;
		_tmp34_ = details;
		_tmp35_ = json_object_get_string_member (_tmp34_, "duration");
		_tmp36_ = atoi (_tmp35_);
		video.duration = _tmp36_ / 60;
	}
	_tmp37_ = g_new0 (gchar*, 0 + 1);
	video.directors = (_vala_array_free (video.directors, video.directors_length1, (GDestroyNotify) g_free), NULL);
	video.directors = _tmp37_;
	video.directors_length1 = 0;
	_tmp38_ = details;
	_tmp39_ = json_object_has_member (_tmp38_, "directors");
	if (_tmp39_) {
		JsonObject* _tmp40_;
		JsonArray* _tmp41_ = NULL;
		JsonArray* _tmp42_;
		JsonArray* directors;
		JsonArray* _tmp43_;
		gint _tmp44_ = 0;
		gchar** _tmp45_ = NULL;
		_tmp40_ = details;
		_tmp41_ = json_object_get_array_member (_tmp40_, "directors");
		_tmp42_ = __vala_JsonArray_copy0 (_tmp41_);
		directors = _tmp42_;
		_tmp43_ = directors;
		_tmp45_ = unity_video_lens_ubuntu_video_search_json_array_to_str_array (_tmp43_, &_tmp44_);
		video.directors = (_vala_array_free (video.directors, video.directors_length1, (GDestroyNotify) g_free), NULL);
		video.directors = _tmp45_;
		video.directors_length1 = _tmp44_;
		__vala_JsonArray_free0 (directors);
	}
	_tmp46_ = details;
	_tmp47_ = json_object_has_member (_tmp46_, "starring");
	if (_tmp47_) {
		JsonObject* _tmp48_;
		JsonArray* _tmp49_ = NULL;
		JsonArray* _tmp50_;
		JsonArray* starring;
		JsonArray* _tmp51_;
		gchar* _tmp52_ = NULL;
		_tmp48_ = details;
		_tmp49_ = json_object_get_array_member (_tmp48_, "starring");
		_tmp50_ = __vala_JsonArray_copy0 (_tmp49_);
		starring = _tmp50_;
		_tmp51_ = starring;
		_tmp52_ = unity_video_lens_ubuntu_video_search_join_array (_tmp51_, ", ");
		_g_free0 (video.starring);
		video.starring = _tmp52_;
		__vala_JsonArray_free0 (starring);
	}
	_tmp53_ = g_new0 (gchar*, 0 + 1);
	video.genres = (_vala_array_free (video.genres, video.genres_length1, (GDestroyNotify) g_free), NULL);
	video.genres = _tmp53_;
	video.genres_length1 = 0;
	_tmp54_ = details;
	_tmp55_ = json_object_has_member (_tmp54_, "genres");
	if (_tmp55_) {
		JsonObject* _tmp56_;
		JsonArray* _tmp57_ = NULL;
		JsonArray* _tmp58_;
		JsonArray* genres;
		JsonArray* _tmp59_;
		gint _tmp60_ = 0;
		gchar** _tmp61_ = NULL;
		_tmp56_ = details;
		_tmp57_ = json_object_get_array_member (_tmp56_, "genres");
		_tmp58_ = __vala_JsonArray_copy0 (_tmp57_);
		genres = _tmp58_;
		_tmp59_ = genres;
		_tmp61_ = unity_video_lens_ubuntu_video_search_json_array_to_str_array (_tmp59_, &_tmp60_);
		video.genres = (_vala_array_free (video.genres, video.genres_length1, (GDestroyNotify) g_free), NULL);
		video.genres = _tmp61_;
		video.genres_length1 = _tmp60_;
		__vala_JsonArray_free0 (genres);
	}
	_tmp62_ = details;
	_tmp63_ = json_object_has_member (_tmp62_, "uploaded_by");
	if (_tmp63_) {
		JsonObject* _tmp64_;
		const gchar* _tmp65_ = NULL;
		gchar* _tmp66_;
		_tmp64_ = details;
		_tmp65_ = json_object_get_string_member (_tmp64_, "uploaded_by");
		_tmp66_ = g_strdup (_tmp65_);
		_g_free0 (video.uploaded_by);
		video.uploaded_by = _tmp66_;
	}
	_tmp67_ = details;
	_tmp68_ = json_object_has_member (_tmp67_, "date_uploaded");
	if (_tmp68_) {
		JsonObject* _tmp69_;
		const gchar* _tmp70_ = NULL;
		gchar* _tmp71_;
		_tmp69_ = details;
		_tmp70_ = json_object_get_string_member (_tmp69_, "date_uploaded");
		_tmp71_ = g_strdup (_tmp70_);
		_g_free0 (video.date_uploaded);
		video.date_uploaded = _tmp71_;
	}
	*result = video;
	__vala_JsonObject_free0 (details);
	_g_object_unref0 (parser);
	return;
}


/**
   * Parses JSON data returned by 'sources' query, returns list of sources (e.g. "Amazon", "Youtube" etc.)
   */
static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		_g_object_unref0 (_data5_->results);
		g_slice_free (Block5Data, _data5_);
	}
}


static void __lambda8_ (Block5Data* _data5_, JsonArray* array, guint index, JsonNode* node) {
	GeeArrayList* _tmp0_;
	JsonNode* _tmp1_;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (array != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = _data5_->results;
	_tmp1_ = node;
	_tmp2_ = json_node_get_string (_tmp1_);
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp2_);
}


static void ___lambda8__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda8_ (self, array, index_, element_node);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GeeArrayList* unity_video_lens_ubuntu_video_search_process_sources_results (const gchar* json_data, GError** error) {
	GeeArrayList* result = NULL;
	Block5Data* _data5_;
	JsonParser* _tmp0_;
	JsonParser* parser;
	const gchar* _tmp1_;
	JsonNode* _tmp2_ = NULL;
	JsonArray* _tmp3_ = NULL;
	JsonArray* _tmp4_;
	JsonArray* sources_array;
	GeeArrayList* _tmp5_;
	JsonArray* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (json_data != NULL, NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_tmp0_ = json_parser_new ();
	parser = _tmp0_;
	_tmp1_ = json_data;
	json_parser_load_from_data (parser, _tmp1_, (gssize) (-1), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (parser);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return NULL;
	}
	_tmp2_ = json_parser_get_root (parser);
	_tmp3_ = json_node_get_array (_tmp2_);
	_tmp4_ = __vala_JsonArray_copy0 (_tmp3_);
	sources_array = _tmp4_;
	_tmp5_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	_data5_->results = _tmp5_;
	_tmp6_ = sources_array;
	json_array_foreach_element (_tmp6_, ___lambda8__json_array_foreach, _data5_);
	_tmp7_ = _data5_->results;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	result = _tmp8_;
	__vala_JsonArray_free0 (sources_array);
	_g_object_unref0 (parser);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



