/*
 * unity-npapi-common.h
 * Copyright (C) Canonical LTD 2012
 * 
 * Author: Alexandre Abreu <alexandre.abreu@canonical.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#if ! defined (UNITY_NPAPI_COMMON_H)
#define UNITY_NPAPI_COMMON_H

#include "npapi-headers/headers/npapi.h"
#include "npapi-headers/headers/nptypes.h"

// methods
typedef NPVariant (*UnityWebAppsNpapiMethodPtr) (NPP instance
						 , NPObject * object
						 , const NPVariant args[]
						 , uint32_t argcnt);

typedef NPVariant (*UnityWebAppsNpapiNamedMethodPtr) (NPP instance
						      , NPObject * object
						      , NPIdentifier name
						      , const NPVariant args[]
						      , uint32_t argcnt);

// array like access
typedef NPVariant (*UnityWebAppsNpapiIndexedGetPtr) (NPP instance
						     , NPObject * object
						     , int32_t idx);

// properties
typedef NPVariant (*UnityWebAppsNpapiPropertyGetPtr) (NPObject * object);
typedef bool (*UnityWebAppsNpapiPropertySetPtr) (NPObject * object, const NPVariant * variant);

typedef struct UnityWebAppsNpapiPropertyDescr_t
{
  UnityWebAppsNpapiPropertyGetPtr get;
  UnityWebAppsNpapiPropertySetPtr set;
  
} UnityWebAppsNpapiPropertyDescr;

// deallocator
typedef void (*UnityWebappsDeallocatorPtr) (NPP instance
					    , NPObject * object);

#endif // UNITY_NPAPI_COMMON_H


