#!/usr/bin/env python

import binascii
from Crypto.PublicKey import RSA
from Crypto.Util.number import long_to_bytes
from winswitch.util.crypt_util import verify_long, sign_long

def main():
	n = 17666880889155803247530548530548552604960431230411415048313891308560318352007972134049791428530862741342016838718763986914838864786404060487198882788465367095009192553824839843604393328434458178167754076022617210447566551509673688775728155306418951044867310144158235459673479983698984762908009948669162741198579986872246400679753016083339544185571332088748956672094382831728168012444023858578872846855219648885882397922267782085224951890237506090703524558576491356110788633675275585830125022103584523490052000017918527514311658512858851455114830211991396247727951776458289489478608429787283307007610759275795900656369
	e = 65537
	d = 10900915961909797087502331835120960224596638816170663926083237510651420625272721930462265068387796626857934860065449716997455696999139530310837365491248646025725647016060681349400711924794125758102257340528290809101403729342938868527898670129559936255128313587888837229630226949369356941002397215378848634032339299414804315085999602686646534125780535663081955806036145728004267166848204068556893467112289229528755898376140058956648137003785310492832854452251443644851886520227026154923290179463848397979112357629761517231244531961138023244052491277715596524628921870362497010669735388667392889128535566648702424349977
	salt = "1be65f35-333e-4027-a67d-0e20d9ff1ce3"
	sig = "0x6b0709bc7cd8a11515c1fa2431fce7900924dfc9dcb2a134aa34f4b5cfb53ea10f0d8d281ecdbbd1bbb6d11e7c7e35bdfab627a8aea62fe3ee2a4fa339ecc1b88e487cc781bb45cce18091b3aff4bf8506ae33a4a31854e18142cb9462fd7a4f331fae89881c923da6ee8e791bd812e89e32615030c735d3aa97b2153e4479fa6e63f11ce52ec7d569f23cd8027b0c686c197a9f4c456079ed83948ecd53fdff76c648ff4dc6959441cec85c0d499ace1bedb9df3efda394eeff551538645feedbff6829ef271104964c291d050ec53d4798c1d4e8d48574f89b8ae39afa9a3f9e7adaa5cd28966aed5a0ee33d9a92296879b3940b718030c6e83c25b5524191"
	key = RSA.construct((long(n), long(e), long(d)))
	assert key.n==n
	assert key.e==e
	assert key.d==d
	print "key=%s" % key

	token = sign_long(key, salt)
	print "signed=%s" % token
	print "long(sig)=%s " % long(sig, 16)
	hexok = "".join(binascii.hexlify(c) for c in long_to_bytes(token))
	print "hex="+binascii.hexlify(long_to_bytes(token))
	print "hex(token)=%s" % hexok
	print "len(hex(token))=%s" % len(hexok)
	x = verify_long(key, salt, sig)
	print "verify=%s" % x


if __name__ == "__main__":
	main()
