/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.AdapterNotFoundException;
import Ice.Current;
import Ice.Identity;
import Ice.Locator;
import Ice.LocatorRegistryPrx;
import Ice.LocatorRegistryPrxHelper;
import Ice.ObjectImpl;
import Ice.ObjectNotFoundException;
import Ice.ObjectPrx;
import Ice.OperationMode;
import IceInternal.BasicStream;
import IceInternal.DispatchStatus;
import IceInternal.Incoming;
import IceUtil.Arrays;

public abstract class _LocatorDisp
extends ObjectImpl
implements Locator {
    public static final String[] __ids = new String[]{"::Ice::Locator", "::Ice::Object"};
    private static final String[] __all = new String[]{"findAdapterById", "findObjectById", "getRegistry", "ice_id", "ice_ids", "ice_isA", "ice_ping"};

    public boolean ice_isA(String string) {
        return Arrays.search(__ids, string) >= 0;
    }

    public boolean ice_isA(String string, Current current) {
        return Arrays.search(__ids, string) >= 0;
    }

    public String[] ice_ids() {
        return __ids;
    }

    public String[] ice_ids(Current current) {
        return __ids;
    }

    public String ice_id() {
        return __ids[0];
    }

    public String ice_id(Current current) {
        return __ids[0];
    }

    public static String ice_staticId() {
        return __ids[0];
    }

    public final ObjectPrx findAdapterById(String string) throws AdapterNotFoundException {
        return this.findAdapterById(string, null);
    }

    public final ObjectPrx findObjectById(Identity identity) throws ObjectNotFoundException {
        return this.findObjectById(identity, null);
    }

    public final LocatorRegistryPrx getRegistry() {
        return this.getRegistry(null);
    }

    public static DispatchStatus ___findObjectById(Locator locator, Incoming incoming, Current current) {
        ObjectImpl.__checkMode(OperationMode.Idempotent, current.mode);
        BasicStream basicStream = incoming.is();
        BasicStream basicStream2 = incoming.os();
        Identity identity = new Identity();
        identity.__read(basicStream);
        try {
            ObjectPrx objectPrx = locator.findObjectById(identity, current);
            basicStream2.writeProxy(objectPrx);
            return DispatchStatus.DispatchOK;
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            basicStream2.writeUserException(objectNotFoundException);
            return DispatchStatus.DispatchUserException;
        }
    }

    public static DispatchStatus ___findAdapterById(Locator locator, Incoming incoming, Current current) {
        ObjectImpl.__checkMode(OperationMode.Idempotent, current.mode);
        BasicStream basicStream = incoming.is();
        BasicStream basicStream2 = incoming.os();
        String string = basicStream.readString();
        try {
            ObjectPrx objectPrx = locator.findAdapterById(string, current);
            basicStream2.writeProxy(objectPrx);
            return DispatchStatus.DispatchOK;
        }
        catch (AdapterNotFoundException adapterNotFoundException) {
            basicStream2.writeUserException(adapterNotFoundException);
            return DispatchStatus.DispatchUserException;
        }
    }

    public static DispatchStatus ___getRegistry(Locator locator, Incoming incoming, Current current) {
        ObjectImpl.__checkMode(OperationMode.Idempotent, current.mode);
        BasicStream basicStream = incoming.os();
        LocatorRegistryPrx locatorRegistryPrx = locator.getRegistry(current);
        LocatorRegistryPrxHelper.__write(basicStream, locatorRegistryPrx);
        return DispatchStatus.DispatchOK;
    }

    public DispatchStatus __dispatch(Incoming incoming, Current current) {
        int n = Arrays.search(__all, current.operation);
        if (n < 0) {
            return DispatchStatus.DispatchOperationNotExist;
        }
        switch (n) {
            case 0: {
                return _LocatorDisp.___findAdapterById(this, incoming, current);
            }
            case 1: {
                return _LocatorDisp.___findObjectById(this, incoming, current);
            }
            case 2: {
                return _LocatorDisp.___getRegistry(this, incoming, current);
            }
            case 3: {
                return ObjectImpl.___ice_id(this, incoming, current);
            }
            case 4: {
                return ObjectImpl.___ice_ids(this, incoming, current);
            }
            case 5: {
                return ObjectImpl.___ice_isA(this, incoming, current);
            }
            case 6: {
                return ObjectImpl.___ice_ping(this, incoming, current);
            }
        }
        return DispatchStatus.DispatchOperationNotExist;
    }

    public abstract /* synthetic */ LocatorRegistryPrx getRegistry(Current var1);

    public abstract /* synthetic */ ObjectPrx findAdapterById(String var1, Current var2) throws AdapterNotFoundException;

    public abstract /* synthetic */ ObjectPrx findObjectById(Identity var1, Current var2) throws ObjectNotFoundException;
}

